/***************************************************************************/
/*  USART0 (polling) driver for NXP LPC800 microcontrollers.               */
/***************************************************************************/
#include "LPC8xx.h"                                // LPC8xx definitions
#include "global.h"

const char ascii[] = "0123456789ABCDEF";

void USART0_Init(uint32_t br)
/***************************/
{
    LPC_SWM->PINASSIGN0 &= 0xFFFFFF04;             // assign U0 TXD to P0_4 ASSIGN0(7:0)
    LPC_SWM->PINASSIGN0 &= 0xFFFF00FF;             // assign U0_RXD to P0_0 ASSIGN0(15:8)
	
    LPC_SYSCON->SYSAHBCLKCTRL |= (1<<14);          // Enable USART0 clock
    LPC_SYSCON->UARTCLKDIV     = 1;                // divided by 1
	
//    LPC_SYSCON->PRESETCTRL    |= (1<<3);           // de-assert ASART0 reset

    LPC_USART0->BRG = (SystemCoreClock/16/br)-1;   // baud rate
    LPC_USART0->CFG = (1<<0)|(1<<2);               // 8 bits, no Parity, 1 Stop bit
}

char ua_inchar(void)	                             // look if there is a character available
/******************/
{
    if (LPC_USART0->STAT & (1<<0))
        return LPC_USART0->RXDATA & 0x7F;          // yes, return character from input buffer
    else
        return 0xFF;                               // no, return -1
}

char ua_getchar(void)                              // wait for a character
/*******************/
{
    while (!(LPC_USART0->STAT & (1<<0))) ;         // receiver ready?
    return LPC_USART0->RXDATA & 0x7F;              // read character from input buffer
}

void ua_outchar(char c)		
/*********************/
{
	  while (!(LPC_USART0->STAT & (1<<2))) ;         // transmitter ready?
    LPC_USART0->TXDATA = c;
}

void PrintByte(unsigned char b)
/*****************************/
{
    ua_outchar(ascii[b >> 4]);
    ua_outchar(ascii[b & 0x0f]);
}

void PrintWord(unsigned short w)
/******************************/
{
    PrintByte((unsigned char)(w>>8));
    PrintByte((unsigned char)w);
}

void PrintString(const char *s)
/*****************************/
{
    while (*s)
    {
        if (*s == '\n')
            ua_outchar('\r');                      // output a '\r' first
        ua_outchar(*s);
        s++;
    }
}
